/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.item.guns;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.attribute.IAttributeProvider;
import dev.toma.gunsrpg.client.render.RenderConfigs;
import dev.toma.gunsrpg.client.render.item.Ump45Renderer;
import dev.toma.gunsrpg.common.attribute.Attribs;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.entity.projectile.AbstractProjectile;
import dev.toma.gunsrpg.common.init.ModSounds;
import dev.toma.gunsrpg.common.init.Skills;
import dev.toma.gunsrpg.common.item.guns.GunItem;
import dev.toma.gunsrpg.common.item.guns.ammo.AmmoMaterials;
import dev.toma.gunsrpg.common.item.guns.setup.WeaponBuilder;
import dev.toma.gunsrpg.common.item.guns.setup.WeaponCategory;
import dev.toma.gunsrpg.common.item.guns.util.Firemode;
import dev.toma.gunsrpg.common.skills.core.SkillType;
import lib.toma.animations.api.IRenderConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Ump45Item
extends GunItem {
    private static final ResourceLocation EJECT = GunsRPG.makeResource("ump45/eject");
    private static final ResourceLocation[] AIM_ANIMATIONS = new ResourceLocation[]{GunsRPG.makeResource("ump45/aim"), GunsRPG.makeResource("ump45/aim_red_dot")};
    private static final ResourceLocation RELOAD_ANIMATION = GunsRPG.makeResource("ump45/reload");
    private static final ResourceLocation UNJAM = GunsRPG.makeResource("ump45/unjam");

    public Ump45Item(String name) {
        super(name, new Item.Properties().setISTER(() -> Ump45Renderer::new).func_200918_c(950));
    }

    @Override
    public void initializeWeapon(WeaponBuilder builder) {
        builder.category(WeaponCategory.SMG).config(GunsRPG.config.weapon.ump).firemodeSelector(Firemode::singleAndFullAuto).ammo().define(AmmoMaterials.WOOD, 0).define(AmmoMaterials.STONE, 1).define(AmmoMaterials.IRON, 3).define(AmmoMaterials.LAPIS, 2).define(AmmoMaterials.GOLD, 4).define(AmmoMaterials.REDSTONE, 3).define(AmmoMaterials.EMERALD, 6).define(AmmoMaterials.QUARTZ, 5).define(AmmoMaterials.DIAMOND, 7).define(AmmoMaterials.AMETHYST, 9).define(AmmoMaterials.NETHERITE, 11).build();
    }

    @Override
    public int getUnjamTime(ItemStack stack) {
        return 60;
    }

    @Override
    protected boolean isSilenced(PlayerEntity player) {
        return PlayerData.hasActiveSkill(player, Skills.UMP45_SUPPRESSOR);
    }

    @Override
    public SoundEvent getShootSound(PlayerEntity entity) {
        return this.isSilenced(entity) ? ModSounds.GUN_UMP9_SILENCED : ModSounds.GUN_UMP9;
    }

    @Override
    protected SoundEvent getEntityShootSound(LivingEntity entity) {
        return ModSounds.MP5;
    }

    @Override
    public int getMaxAmmo(IAttributeProvider provider) {
        return provider.getAttribute(Attribs.UMP45_MAG_CAPACITY).intValue();
    }

    @Override
    public int getReloadTime(IAttributeProvider provider, ItemStack stack) {
        return Attribs.UMP45_RELOAD.intValue(provider);
    }

    @Override
    public int getFirerate(IAttributeProvider provider) {
        return provider.getAttribute(Attribs.UMP45_FIRERATE).intValue();
    }

    @Override
    public float getVerticalRecoil(IAttributeProvider provider) {
        return Attribs.UMP45_VERTICAL.floatValue(provider);
    }

    @Override
    public float getHorizontalRecoil(IAttributeProvider provider) {
        return 0.7f * super.getHorizontalRecoil(provider);
    }

    @Override
    public double getNoiseMultiplier(IAttributeProvider provider) {
        return Attribs.UMP45_LOUDNESS.value(provider);
    }

    @Override
    public void onKillEntity(AbstractProjectile bullet, LivingEntity victim, ItemStack stack, LivingEntity shooter) {
        if (shooter instanceof PlayerEntity && victim instanceof MonsterEntity && PlayerData.hasActiveSkill((PlayerEntity)shooter, Skills.UMP45_COMMANDO)) {
            shooter.func_195064_c(new EffectInstance(Effects.field_76424_c, 100, 1, false, false));
            shooter.func_195064_c(new EffectInstance(Effects.field_76428_l, 75, 1, false, false));
        }
    }

    @Override
    public SkillType<?> getRequiredSkill() {
        return Skills.UMP45_ASSEMBLY;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getAimAnimationPath(ItemStack stack, PlayerEntity player) {
        boolean rds = PlayerData.hasActiveSkill((PlayerEntity)Minecraft.func_71410_x().field_71439_g, Skills.UMP45_RED_DOT);
        return AIM_ANIMATIONS[rds ? 1 : 0];
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getBulletEjectAnimationPath() {
        return EJECT;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getReloadAnimation(PlayerEntity player) {
        return RELOAD_ANIMATION;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getUnjamAnimationPath() {
        return UNJAM;
    }

    @Override
    public IRenderConfig left() {
        return RenderConfigs.UMP45_LEFT;
    }

    @Override
    public IRenderConfig right() {
        return RenderConfigs.UMP45_RIGHT;
    }
}

